﻿using System;
using Renci.SshNet;
using System.IO;
using System.ComponentModel;
using System.Windows;
using Activa_ACH.Interfaces;
using Activa_ACH.Properties;

namespace Activa_ACH.Services
{
	class SenderService : NetService
	{
		#region Fields
		private bool _TransferingNACHA = false;
		private int _NACHAProgress = 0;
		private bool _TransferingVerification = false;
		private int _VerificationProgress = 0;
		private bool _NACHAComplete = false;
		private bool _VerificationComplete = false;
		private StreamWriter _NACHAWriter;
		private StreamWriter _VerificationWriter;
		#endregion

		#region properties
		public bool TransferingNACHA
		{
			get
			{
				return _TransferingNACHA;
			}

			set
			{
				if (_TransferingNACHA != value)
				{
					_TransferingNACHA = value;
					OnPropertyChanged("TransferingNACHA");
				}
			}
		}

		public int NACHAProgress
		{
			get
			{
				return _NACHAProgress;
			}

			set
			{
				if(_NACHAProgress != value)
				{
					_NACHAProgress = value;
					OnPropertyChanged("NACHAProgress");
				}
			}
		}

		public bool TransferingVerification
		{
			get
			{
				return _TransferingVerification;
			}

			set
			{
				if(_TransferingVerification != value)
				{
					_TransferingVerification = value;
					OnPropertyChanged("TransferingVerification");
				}
			}
		}

		public int VerificationProgress
		{
			get
			{
				return _VerificationProgress;
			}

			set
			{
				if(_VerificationProgress != value)
				{
					_VerificationProgress = value;
					OnPropertyChanged("VerificationProgress");
				}
			}
		}

		public bool NACHAComplete
		{
			get
			{
				return _NACHAComplete;
			}

			set
			{
				if (_NACHAComplete != value)
				{
					_NACHAComplete = value;
					OnPropertyChanged("NACHAComplete");
				}
			}
		}

		public bool VerificationComplete
		{
			get
			{
				return _VerificationComplete;
			}

			set
			{
				if(_VerificationComplete != value)
				{
					_VerificationComplete = value;
					OnPropertyChanged("VerificationComplete");
				}
			}
		}

		public MemoryStream VerificationMemStream = new MemoryStream();
		#endregion

		#region Constructor
		public SenderService(IWorkFile File)
		{
			CurrentFile = File;
			PropertyChanged += PropertyChange;
		}
		#endregion

		#region Destructor
		~SenderService()
		{
			if (_NACHAWriter != null)
				_NACHAWriter.Dispose();
			if (_VerificationWriter != null)
				_VerificationWriter.Dispose();
			if (MemStream != null)
				MemStream.Dispose();
			if (VerificationMemStream != null)
				VerificationMemStream.Dispose();
			PropertyChanged -= PropertyChange;
		}
		#endregion

		#region methods
		private void PropertyChange(object sender, PropertyChangedEventArgs e)
		{
			if (e.PropertyName == "NACHAComplete" || e.PropertyName == "VerificationComplete")
			{
				if (NACHAComplete && VerificationComplete)
				{
					Completed = true;
				}
			}
		}

		public void SendFile()
		{
			using(var sFTP = new SftpClient(
				Settings.Default.bankHost,
				Settings.Default.bankUser,
				Settings.Default.bankPassword
				))
			{
				Connecting = true;
				try
				{
					sFTP.Connect();
				}
				catch (Exception ex)
				{
					Console.WriteLine(ex.Message);
					MessageBox.Show(ex.Message);
					return;
				}
				Connecting = false;
				Connected = true;

				_NACHAWriter = new StreamWriter(MemStream);
				_VerificationWriter = new StreamWriter(VerificationMemStream);
				_NACHAWriter.Write(CurrentFile.ToString());
				_VerificationWriter.Write(CurrentFile.GetVerificationFile());
				_NACHAWriter.Flush();
				_VerificationWriter.Flush();

				TransferingNACHA = true;
				if (MemStream.Position > 0)
					MemStream.Position = 0;
				sFTP.UploadFile(
					MemStream,
					Settings.Default.bankWorkingDirectory + ((Settings.Default.bankWorkingDirectory.EndsWith("/")) ? "" : "/") + Settings.Default.bankNACHAName,
					(offset) =>
					{
						NACHAProgress = (int)Math.Ceiling((double)(offset / (ulong)MemStream.Length));
						if (offset == (ulong)MemStream.Length)
						{
							TransferingNACHA = false;
							NACHAComplete = true;
						}
					});

				if (VerificationMemStream.Position > 0)
					VerificationMemStream.Position = 0;
				sFTP.UploadFile(
					VerificationMemStream,
					Settings.Default.bankWorkingDirectory + ((Settings.Default.bankWorkingDirectory.EndsWith("/")) ? "" : "/") + Settings.Default.bankVerificationName,
					(offset) =>
					{
						VerificationProgress = (int)Math.Ceiling((double)(offset / (ulong)VerificationMemStream.Length));
						if (offset == (ulong)VerificationMemStream.Length)
						{
							TransferingVerification = false;
							VerificationComplete = true;
						}
					});
			}
		}
		#endregion
	}
}
