﻿using System;
using System.Linq;
using Renci.SshNet;
using Renci.SshNet.Sftp;
using System.IO;
using Activa_ACH.Interfaces;
using System.ComponentModel;
using System.Windows;
using Activa_ACH.Properties;

namespace Activa_ACH.Services
{
	class ReceiverService : NetService
	{
		#region Fields
		private bool _filefound = false;
		private bool _lookingForFile = false;
		private bool _transfering = false;
		private int _progress = 0;
		#endregion

		#region properties
		public bool FileFound
		{
			get
			{
				return _filefound;
			}

			set
			{
				if (_filefound != value)
				{
					_filefound = value;
					OnPropertyChanged("FileFound");
				}
			}
		}

		public bool LookingForFile
		{
			get
			{
				return _lookingForFile;
			}

			set
			{
				if (_lookingForFile != value)
				{
					_lookingForFile = value;
					OnPropertyChanged("LookingForFile");
				}
			}
		}

		public int Progress
		{
			get
			{
				return _progress;
			}
			set
			{
				if (_progress != value)
				{
					_progress = value;
					OnPropertyChanged("Progress");
				}
			}
		}

		public bool Transfering
		{
			get
			{
				return _transfering;
			}

			set
			{
				if (_transfering != value)
				{
					_transfering = value;
					OnPropertyChanged("Transfering");
				}
			}
		}
		#endregion

		#region Constructor
		public ReceiverService(IWorkFile File)
		{
			CurrentFile = File;
			PropertyChanged += PropertyChange;
		}
		#endregion

		#region Destructor
		~ReceiverService()
		{
			if (MemStream != null)
				MemStream.Dispose();
			PropertyChanged -= PropertyChange;
		}
		#endregion

		#region methods
		private void PropertyChange(object sender, PropertyChangedEventArgs e)
		{
			if (e.PropertyName == "Completed" && Completed == true)
			{
				MemStream.Position = 0;
				StreamReader SR = new StreamReader(MemStream);
				CurrentFile.Lines = SR.ReadToEnd().Split('\n').ToList();
			}
		}

		public void GetFile()
		{
			using (var sFTP = new SftpClient(
				Settings.Default.luminxHost,
				Settings.Default.luminxUser,
				Settings.Default.luminxPassword
				))
			{
				Connecting = true;
				SftpFile file;
				string filePath = "";
				ulong fileSize = 0;
				try
				{
					sFTP.Connect();
				}
				catch(Exception ex)
				{
					Console.WriteLine(ex.Message);
					MessageBox.Show(ex.Message);
					return;
				}
				Connecting = false;
				Connected = true;

				LookingForFile = true;
				try
				{
					var path = Settings.Default.luminxWorkingDirectory + ((Settings.Default.luminxWorkingDirectory.EndsWith("/")) ? "" : "/") + CurrentFile.FileName;
					file = sFTP.Get(path);
					filePath = file.FullName;
					fileSize = (ulong)file.Length;
				}
				catch (Exception ex)
				{
					Console.WriteLine(ex.Message);
					MessageBox.Show(ex.Message);
					return;
				}
				LookingForFile = false;
				FileFound = true;

				if(MemStream.Position > 0)
					MemStream.Position = 0;
				Transfering = true;
				sFTP.DownloadFile(
					filePath,
					MemStream,
					(offset) => {
						Progress = (int)Math.Ceiling((double)(offset / fileSize));
						if(offset == fileSize)
						{
							Transfering = false;
							Completed = true;
						}
					}
					);
			}
		}
		#endregion
	}
}
