﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using Activa_ACH.Helpers;
using System.IO;
using Activa_ACH.Services;
using Activa_ACH.Data;
using Activa_ACH.Interfaces;

namespace Activa_ACH.Services
{
	class NetService : ObservableObject
	{
		#region Fields
		private bool _connecting = false;
		private bool _connected = false;
		private bool _completed = false;
		#endregion

		#region properties
		public IWorkFile CurrentFile { get; set; }
		public bool Completed
		{
			get
			{
				return _completed;
			}
			set
			{
				if (_completed != value)
				{
					_completed = value;
					OnPropertyChanged("Completed");
				}
			}
		}

		public bool Connecting
		{
			get
			{
				return _connecting;
			}

			set
			{
				if(_connecting != value)
				{
					_connecting = value;
					OnPropertyChanged("Connecting");
				}
			}
		}

		public bool Connected
		{
			get
			{
				return _connected;
			}

			set
			{
				if(_connected != value)
				{
					_connected = value;
					OnPropertyChanged("Connected");
				}
			}
		}

		public MemoryStream MemStream = new MemoryStream();
		#endregion

		#region Methods
		public override string ToString()
		{
			return MemStream.ToString();
		}
		#endregion
	}
}
