﻿using System;
using System.Linq;
using Activa_ACH.Interfaces;
using Activa_ACH.Helpers;

namespace Activa_ACH.Services
{
	class ConverterService : ObservableObject
	{
		#region Fields
		private IWorkFile _currentFile;
		private int _progress = 0;
		private int _lineCount = 0;
		private bool _converting = false;
		private bool _completed = false;
		private string company_name = "Insight Benefit Administrators";
		private string company_id = "1811724527";
		private string routing_number = "072000096";
		private string origin_dfi = "07200009";
		private string bank_name = "Comerica Bank";
		private int debitCount = 0;
		private int creditCount = 0;
		private double debitTotal = 0;
		private double creditTotal = 0;
		#endregion

		#region Constructors
		public ConverterService(IWorkFile File)
		{
			_currentFile = File;
		}
		#endregion

		#region Properties/Commands
		public int Progress
		{
			get
			{
				return _progress;
			}

			set
			{
				if (_progress != value)
				{
					_progress = value;
					OnPropertyChanged("Progress");
				}
			}
		}

		public bool Completed
		{
			get
			{
				return _completed;
			}

			set
			{
				if (_completed != value)
				{
					_completed = value;
					OnPropertyChanged("Completed");
				}
			}
		}

		public bool Converting
		{
			get
			{
				return _converting;
			}

			set
			{
				if (_converting != value)
				{
					_converting = value;
					OnPropertyChanged("Converting");
				}
			}
		}
		#endregion

		#region Method
		public void ConvertFile()
		{
			Progress = 0;
			Converting = true;
			_currentFile.Lines = (
									from str in _currentFile.Lines
									select ModifyLine(str)
								 ).ToList();
			_currentFile.CreditCount = creditCount;
			_currentFile.DebitCount = debitCount;
			_currentFile.CreditTotal = creditTotal;
			_currentFile.DebitTotal = debitTotal;
			Converting = false;
			Completed = true;
		}

		private string ModifyLine(string str)
		{
			if (str.StartsWith("1"))
			{
				str = str.Remove(3, 10)
					.Insert(3, routing_number.PadLeft(10, ' ').LimitTo(10));

				str = str.Remove(13, 10)
					.Insert(13, company_id.PadLeft(10, ' ').LimitTo(10));

				str = str.Remove(40, 23)
					.Insert(40, bank_name.PadRight(23, ' ').LimitTo(23));

				str = str.Remove(63, 23)
					.Insert(63, company_name.PadRight(23, ' ').LimitTo(23));
			}
			if (str.StartsWith("5"))
			{
				str = str.Remove(40, 10)
					.Insert(40, company_id.PadLeft(10, ' '));

				str = str.Remove(69, 6)
					.Insert(69, _currentFile.EffectiveDate.ToString("yyMMdd"));

				str = str.Remove(79, 8)
					.Insert(79, origin_dfi.PadLeft(8, ' '));
			}
			if (str.StartsWith("6"))
			{
				str = str.Remove(39, 5)
					.Insert(39, "".PadLeft(5, '*'));

				str = str.Remove(79, 8)
					.Insert(79, origin_dfi.PadLeft(8, ' '));


				double amount = 0;
				double.TryParse(str.Substring(29, 10), out amount);
				amount /= 100;
				if (str[2] == '2')
				{
					creditCount++;
					creditTotal += amount;
				}
				if (str[2] == '7')
				{
					debitCount++;
					debitTotal += amount;
				}
			}
			if (str.StartsWith("8"))
			{
				str = str.Remove(44, 10)
					.Insert(44, company_id.PadLeft(10, ' '));

				str = str.Remove(79, 8)
					.Insert(79, origin_dfi.PadLeft(8, ' '));
			}
			_lineCount++;
			Progress = (int)Math.Ceiling((double)(_lineCount / _currentFile.Lines.Count));
			return str;
		}
		#endregion
	}
}
