﻿using Activa_ACH.Helpers;
using Activa_ACH.Interfaces;
using System.ComponentModel;
using Activa_ACH.Services;
using System.Threading;
using System.Windows.Input;

namespace Activa_ACH.Pages
{
	class SendViewModel : ObservableObject, IPageViewModel
	{
		#region Fields

		const string _Name = "Send";
		private IWorkFile _currentFile;
		private IApplicationModel _app;
		private ICommand _CancelSendCommand;
		private bool _converted;
		private bool _converting;
		private int _convertingProgress;

		private bool _connecting;
		private bool _connected;

		private bool _sendingNACHA;
		private bool _sentNACHA;
		private int _sendingNACHAProgress;

		private bool _sendingVerification;
		private bool _sentVerification;
		private int _sendingVerificationProgress;

		private SenderService _senderService;
		private Thread _sendThread;
		private Thread _convertThread;
		#endregion

		#region Constructors
		public SendViewModel(IApplicationModel App, IWorkFile File)
		{
			_app = App;
			_currentFile = File;
			_app.PropertyChanged += _ApplicationPropertyChange;
			ClearPage();
		}
		#endregion

		#region Destructors
		~SendViewModel()
		{
			_app.PropertyChanged -= _ApplicationPropertyChange;
			if (_senderService != null)
				_senderService.PropertyChanged -= _senderService_PropertyChanged;
		}
		#endregion

		#region Properties/Commands

		public string Name
		{
			get { return _Name; }
		}

		public bool Converted
		{
			get
			{
				return _converted;
			}

			set
			{
				if(_converted != value)
				{
					_converted = value;
					OnPropertyChanged("Converted");
				}
			}
		}

		public bool Converting
		{
			get
			{
				return _converting;
			}

			set
			{
				if(_converting != value)
				{
					_converting = value;
					OnPropertyChanged("Converting");
				}
			}
		}

		public int ConvertingProgress
		{
			get
			{
				return _convertingProgress;
			}

			set
			{
				if(_convertingProgress != value)
				{
					_convertingProgress = value;
					OnPropertyChanged("ConvertingProgress");
				}
			}
		}

		public bool Connecting
		{
			get
			{
				return _connecting;
			}

			set
			{
				if(_connecting != value)
				{
					_connecting = value;
					OnPropertyChanged("Connecting");
				}
			}
		}

		public bool Connected
		{
			get
			{
				return _connected;
			}

			set
			{
				if(_connected != value)
				{
					_connected = value;
					OnPropertyChanged("Connected");
				}
			}
		}

		public bool SendingNACHA
		{
			get
			{
				return _sendingNACHA;
			}

			set
			{
				if(_sendingNACHA != value)
				{
					_sendingNACHA = value;
					OnPropertyChanged("SendingNACHA");
				}
			}
		}

		public bool SentNACHA
		{
			get
			{
				return _sentNACHA;
			}

			set
			{
				if(_sentNACHA != value)
				{
					_sentNACHA = value;
					OnPropertyChanged("SentNACHA");
				}
			}
		}

		public int SendingNACHAProgress
		{
			get
			{
				return _sendingNACHAProgress;
			}

			set
			{
				if(_sendingNACHAProgress != value)
				{
					_sendingNACHAProgress = value;
					OnPropertyChanged("SendingNACHAProgress");
				}
			}
		}

		public bool SendingVerification
		{
			get
			{
				return _sendingVerification;
			}

			set
			{
				if(_sendingVerification != value)
				{
					_sendingVerification = value;
					OnPropertyChanged("SendingVerification");
				}
			}
		}

		public bool SentVerification
		{
			get
			{
				return _sentVerification;
			}

			set
			{
				if(_sentVerification != value)
				{
					_sentVerification = value;
					OnPropertyChanged("SentVerification");
				}
			}
		}

		public int SendingVerificationProgress
		{
			get
			{
				return _sendingVerificationProgress;
			}

			set
			{
				if(_sendingVerificationProgress != value)
				{
					_sendingVerificationProgress = value;
					OnPropertyChanged("SendingVerificationProgress");
				}
			}
		}

		public ICommand CancelSend
		{
			get
			{
				if (_CancelSendCommand == null)
				{
					_CancelSendCommand = new RelayCommand(
						p => _cancelSend(),
						p => true);
				}
				return _CancelSendCommand;
			}
		}

		#endregion

		#region Methods
		
		private void _cancelSend()
		{
			if (_convertThread != null)
			{
				if (_convertThread.IsAlive)
					_convertThread.Abort();
			}
			if (_sendThread != null)
			{
				if (_sendThread.IsAlive)
					_sendThread.Abort();
			}
			_currentFile.Clear();
			_app.ChangeViewModel("Home");
		}

		private void _ApplicationPropertyChange(object sender, PropertyChangedEventArgs e)
		{
			if (e.PropertyName == "CurrentPageViewModel" && _app.CurrentView == Name)
			{
				if (_currentFile.Approved)
				{
					//Clear Page and start the Send
					ClearPage();
				
					ConverterService CS = new ConverterService(_currentFile);
					CS.PropertyChanged += CS_PropertyChanged;
					_senderService = new SenderService(_currentFile);
					_senderService.PropertyChanged += _senderService_PropertyChanged;

					_convertThread = new Thread(new ThreadStart(CS.ConvertFile));
					_convertThread.Start();
				}
			}
		}

		private void CS_PropertyChanged(object sender, PropertyChangedEventArgs e)
		{
			if (e.PropertyName == "Converting")
			{
				Converting = ((ConverterService)sender).Converting;
			}
			if(e.PropertyName == "Progress")
			{
				ConvertingProgress = ((ConverterService)sender).Progress;
			}
			if (e.PropertyName == "Completed")
			{
				Converted = ((ConverterService)sender).Completed;
				if (Converted == true)
				{
					((ConverterService)sender).PropertyChanged -= CS_PropertyChanged;
					_sendThread = new Thread(new ThreadStart(_RunSenderSendFile));
					_sendThread.Start();
				}
			}
		}

		private void _RunSenderSendFile()
		{
			_senderService.SendFile();
		}

		private void _senderService_PropertyChanged(object sender, PropertyChangedEventArgs e)
		{
			switch (e.PropertyName)
			{
				case "Connecting":
					Connecting = ((SenderService)sender).Connecting;
					break;
				case "Connected":
					Connected = ((SenderService)sender).Connected;
					break;
				case "TransferingNACHA":
					SendingNACHA = ((SenderService)sender).TransferingNACHA;
					break;
				case "NACHAProgress":
					SendingNACHAProgress = ((SenderService)sender).NACHAProgress;
					break;
				case "TransferingVerification":
					SendingVerification = ((SenderService)sender).TransferingVerification;
					break;
				case "VerificationProgress":
					SendingVerificationProgress = ((SenderService)sender).VerificationProgress;
					break;
				case "Completed":
					_currentFile.Sent = true;
					_app.ChangeViewModel("Complete");
					break;
				case "NACHAComplete":
					SentNACHA = ((SenderService)sender).NACHAComplete;
					break;
				case "VerificationComplete":
					SentVerification = ((SenderService)sender).VerificationComplete;
					break;
			}
		}

		private void ClearPage()
		{
			Converted = false;
			Converting = false;
			ConvertingProgress = 0;

			Connecting = false;
			Connected = false;

			SendingNACHA = false;
			SentNACHA = false;
			SendingNACHAProgress = 0;

			SendingVerification = false;
			SentVerification = false;
			SendingVerificationProgress = 0;
		}

		#endregion
	}
}
