﻿using Activa_ACH.Helpers;
using Activa_ACH.Interfaces;
using System.ComponentModel;
using Activa_ACH.Services;
using System.Threading;
using System.Windows.Input;

namespace Activa_ACH.Pages
{
	class ReceiveViewModel : ObservableObject, IPageViewModel
	{
		#region Fields
		const string _Name = "Receive";
		private IWorkFile _currentFile;
		private IApplicationModel _app;
		private ICommand _cancelReceiveCommand;
		private ReceiverService _receiverService = null;
		private Thread _receiveThread;

		private bool _connecting = false;
		private bool _connected = false;
		private bool _lookingForFile = false;
		private bool _filefound = false;
		private bool _downloaded = false;
		private bool _downloading = false;
		private int _downloadProgress = 0;
		#endregion

		#region Constructors
		public ReceiveViewModel(IApplicationModel App, IWorkFile File)
		{
			_app = App;
			_currentFile = File;
			_app.PropertyChanged += _ApplicationPropertyChange;
			ClearPage();
		}
		#endregion

		#region Destructors
		~ReceiveViewModel()
		{
			_app.PropertyChanged -= _ApplicationPropertyChange;
			if (_receiverService != null)
				_receiverService.PropertyChanged -= Receiver_PropertyChanged;
		}
		#endregion

		#region Properties/Commands

		public string Name
		{
			get { return _Name; }
		}

		public int DownloadProgress
		{
			get
			{
				return _downloadProgress;
			}

			set
			{
				if (_downloadProgress != value)
				{
					_downloadProgress = value;
					OnPropertyChanged("DownloadProgress");
				}
			}
		}

		public bool Downloaded
		{
			get
			{
				return _downloaded;
			}

			set
			{
				if (_downloaded != value)
				{
					_downloaded = value;
					OnPropertyChanged("Downloaded");
				}
			}
		}

		public bool Downloading
		{
			get
			{
				return _downloading;
			}

			set
			{
				if (_downloading != value)
				{
					_downloading = value;
					OnPropertyChanged("Downloading");
				}
			}
		}

		public bool FileFound
		{
			get
			{
				return _filefound;
			}

			set
			{
				if (_filefound != value)
				{
					_filefound = value;
					OnPropertyChanged("FileFound");
				}
			}
		}

		public bool LookingForFile
		{
			get
			{
				return _lookingForFile;
			}

			set
			{
				if (_lookingForFile != value)
				{
					_lookingForFile = value;
					OnPropertyChanged("LookingForFile");
				}
			}
		}

		public bool Connected
		{
			get
			{
				return _connected;
			}

			set
			{
				if (_connected != value)
				{
					_connected = value;
					OnPropertyChanged("Connected");
				}
			}
		}

		public bool Connecting
		{
			get
			{
				return _connecting;
			}

			set
			{
				if (_connecting != value)
				{
					_connecting = value;
					OnPropertyChanged("Connecting");
				}
			}
		}
		
		public ICommand CancelReceive
		{
			get
			{
				if (_cancelReceiveCommand == null)
				{
					_cancelReceiveCommand = new RelayCommand(
						p => _cancelReceive(),
						p => true);
				}
				return _cancelReceiveCommand;
			}
		}

		#endregion

		#region Methods

		private void _cancelReceive()
		{
			if (_receiveThread != null)
			{
				if (_receiveThread.IsAlive)
					_receiveThread.Abort();
			}
			_currentFile.Clear();
			_app.ChangeViewModel("Home");
		}

		private void _ApplicationPropertyChange(object sender, PropertyChangedEventArgs e)
		{
			if (e.PropertyName == "CurrentPageViewModel" && _app.CurrentView == Name)
			{
				//Clear Page and start the Receive
				ClearPage();
				_receiverService = new ReceiverService(_currentFile);
				_receiverService.PropertyChanged += Receiver_PropertyChanged;
				_receiveThread = new Thread(new ThreadStart(_RunReceiverGetFile));
				_receiveThread.Start();
			}
		}
		
		private void _RunReceiverGetFile()
		{
			_receiverService.GetFile();
		}

		private void Receiver_PropertyChanged(object sender, PropertyChangedEventArgs e)
		{
			switch (e.PropertyName)
			{
				case "Progress":
					DownloadProgress = ((ReceiverService)sender).Progress;
					break;
				case "Completed":
					Downloaded = ((ReceiverService)sender).Completed;
					_currentFile.Downloaded = ((ReceiverService)sender).Completed;
					_app.ChangeViewModel("Approve");
					break;
				case "Connecting":
					Connecting = ((ReceiverService)sender).Connecting;
					break;
				case "Connected":
					Connected = ((ReceiverService)sender).Connected;
					break;
				case "LookingForFile":
					LookingForFile = ((ReceiverService)sender).LookingForFile;
					break;
				case "FileFound":
					FileFound = ((ReceiverService)sender).FileFound;
					break;
				case "Transfering":
					Downloading = ((ReceiverService)sender).Transfering;
					break;
			}
		}

		private void ClearPage()
		{
			Connected = false;
			Connecting = false;
			LookingForFile = false;
			FileFound = false;
			Downloaded = false;
			Downloading = false;
			DownloadProgress = 0;
		}

		#endregion
	}
}
