﻿using System;
using System.Windows.Input;
using Activa_ACH.Helpers;
using Activa_ACH.Interfaces;
using System.ComponentModel;

namespace Activa_ACH.Pages
{
	class HomeViewModel : ObservableObject, IPageViewModel
	{
		#region Fields
		const string _Name = "Home";
		private IWorkFile _currentFile;
		private IApplicationModel _app;
		private DateTime _EffectiveDate = DateTime.Now;
		private string _FileName = "";
		private ICommand _clearPageCommand;
		private ICommand _startProcess;
		//private ICommand _settingsWindowCommand;
		#endregion

		#region Constructors
		public HomeViewModel(IApplicationModel App, IWorkFile File)
		{
			_app = App;
			_currentFile = File;
			_app.PropertyChanged += _ApplicationPropertyChange;
			ResetViewModel();
		}
		#endregion

		#region Destructors
		~HomeViewModel()
		{
			_app.PropertyChanged -= _ApplicationPropertyChange;
		}
		#endregion

		#region Properties/Commands

		public string Name
		{
			get { return _Name; }
		}

		public DateTime EffectiveDate
		{
			get { return _EffectiveDate; }
			set
			{
				if (value != _EffectiveDate)
				{
					_EffectiveDate = value;
					OnPropertyChanged("EffectiveDate");
				}
			}
		}

		public string FileName
		{
			get { return _FileName; }
			set
			{
				if (value != _FileName)
				{
					_FileName = value;
					OnPropertyChanged("FileName");
				}
			}
		}

		public ICommand ClearPageCommand
		{
			get
			{
				if (_clearPageCommand == null)
				{
					_clearPageCommand = new RelayCommand(
						p => ResetViewModel(),
						p => (EffectiveDate > DateTime.Now || FileName != ""));
				}

				return _clearPageCommand;
			}
		}

		public ICommand StartProcess
		{
			get
			{
				if (_startProcess == null)
				{
					_startProcess = new RelayCommand(
						p => StartACH((string)p),
						p => (EffectiveDate > DateTime.Now && FileName != ""));
				}
				return _startProcess;
			}
		}

		//public ICommand SettingsWindowCommand
		//{
		//	get
		//	{
		//		if (_settingsWindowCommand == null)
		//		{
		//			_settingsWindowCommand = new RelayCommand(
		//				p => _app.SettingsModal.Show(),
		//				p => true);
		//		}
		//		return _settingsWindowCommand;
		//	}
		//}
		#endregion

		#region Methods

		private void _ApplicationPropertyChange(object sender, PropertyChangedEventArgs e)
		{
			if (e.PropertyName == "CurrentPageViewModel" && _app.CurrentView == Name)
			{
				//Clear Page
				ResetViewModel();
			}
		}

		private void ResetViewModel()
		{
			FileName = "";
			EffectiveDate = DateTime.Now.AddDays(1);
		}

		private void StartACH(string viewModel)
		{
			_currentFile.FileName = FileName;
			_currentFile.EffectiveDate = EffectiveDate;
			_app.ChangeViewModel(viewModel);
		}

		#endregion
	}
}
