﻿using Activa_ACH.Helpers;
using Activa_ACH.Interfaces;
using System.ComponentModel;
using Activa_ACH.Properties;
using System.Windows.Input;

namespace Activa_ACH.Pages
{
	class CompleteViewModel : ObservableObject, IPageViewModel
	{
		#region Fields
		private const string _Name = "Complete";
		private string _message = "";
		private IWorkFile _currentFile;
		private IApplicationModel _app;
		private ICommand _newProcessCommand;
		private ICommand _exitWindowCommand;
		#endregion

		#region Constructors
		public CompleteViewModel(IApplicationModel App, IWorkFile File)
		{
			_app = App;
			_currentFile = File;
			_app.PropertyChanged += _ApplicationPropertyChange;
			ClearPage();
		}
		#endregion

		#region Destructors
		~CompleteViewModel()
		{
			_app.PropertyChanged -= _ApplicationPropertyChange;
		}
		#endregion

		#region Properties/Commands

		public string Name
		{
			get { return _Name; }
		}

		public string Message
		{
			get { return _message; }
			set
			{
				if (_message != value)
				{
					_message = value;
					OnPropertyChanged("Message");
				}
			}
		}

		public ICommand NewProcess
		{
			get
			{
				if (_newProcessCommand == null)
				{
					_newProcessCommand = new RelayCommand(
						p => _newProcess(),
						p => true);
				}
				return _newProcessCommand;
			}
		}

		public ICommand ExitWindow
		{
			get
			{
				if (_exitWindowCommand == null)
				{
					_exitWindowCommand = new RelayCommand(
						p => _exitWindow(),
						p => true);
				}
				return _exitWindowCommand;
			}
		}

		#endregion

		#region Methods

		private void _newProcess()
		{
			_currentFile.Clear();
			_app.ChangeViewModel("Home");
		}

		private void _exitWindow()
		{
			App.Current.MainWindow.Close();
		}

		private void _ApplicationPropertyChange(object sender, PropertyChangedEventArgs e)
		{
			if (e.PropertyName == "CurrentPageViewModel" && _app.CurrentView == Name)
			{
				//Clear Page and Display Message
				ClearPage();
				if (_currentFile.Sent)
				{
					Message = Settings.Default.CompleteSuccessMessage.Replace("%file%", _currentFile.FileName);
				}
				else
					Message = Settings.Default.CompleteFailMessage.Replace("%file%", _currentFile.FileName);
			}
		}

		private void ClearPage()
		{
			Message = "";
		}

		#endregion
	}
}
