﻿using Activa_ACH.Helpers;
using Activa_ACH.Interfaces;
using System.ComponentModel;
using System.Windows.Input;
using System.Linq;

namespace Activa_ACH.Pages
{
	class ApproveViewModel : ObservableObject, IPageViewModel
	{
		#region Fields

		const string _Name = "Approve";
		private IWorkFile _currentFile;
		private IApplicationModel _app;
		private int _records;
		private double _total;
		private ICommand _cancelApproveCommand;
		private ICommand _ApproveCommand;
		#endregion

		#region Constructors
		public ApproveViewModel(IApplicationModel App, IWorkFile File)
		{
			_app = App;
			_currentFile = File;
			_app.PropertyChanged += _ApplicationPropertyChange;
			ClearPage();
		}
		#endregion

		#region Destructors
		~ApproveViewModel()
		{
			_app.PropertyChanged -= _ApplicationPropertyChange;
		}
		#endregion

		#region Properties/Commands

		public string Name
		{
			get { return _Name; }
		}

		public int Records
		{
			get
			{
				return _records;
			}

			set
			{
				if (_records != value)
				{
					_records = value;
					OnPropertyChanged("Records");
				}
			}
		}

		public double Total
		{
			get
			{
				return _total;
			}

			set
			{
				if(_total != value)
				{
					_total = value;
					OnPropertyChanged("Total");
				}
			}
		}
		
		public ICommand ApproveCommand
		{
			get
			{
				if (_ApproveCommand == null)
				{
					_ApproveCommand = new RelayCommand(
						p => _Approve(),
						p => _currentFile.Downloaded);
				}
				return _ApproveCommand;
			}
		}

		public ICommand CancelApproveCommand
		{
			get
			{
				if (_cancelApproveCommand == null)
				{
					_cancelApproveCommand = new RelayCommand(
						p => _CancelApprove(),
						p => true);
				}
				return _cancelApproveCommand;
			}
		}

		#endregion

		#region Methods

		private void _Approve()
		{
			_currentFile.Approved = true;
			_app.ChangeViewModel("Send");
		}
		private void _CancelApprove()
		{
			_app.ChangeViewModel("Home");
		}

		private void _ApplicationPropertyChange(object sender, PropertyChangedEventArgs e)
		{
			if (e.PropertyName == "CurrentPageViewModel" && _app.CurrentView == Name)
			{
				//Clear Page and setup the page
				ClearPage();
				if(_currentFile.Lines.Count > 0)
				{
					var Entries = _currentFile.Lines.Where(s => s.StartsWith("6"));
					Records = Entries.Count();
					foreach(var str in Entries)
					{
						double amount = 0;
						double.TryParse(str.Substring(29, 10), out amount);
						amount /= 100;
						Total += amount;
					}
				}
			}
		}

		private void ClearPage()
		{
			Records = 0;
			Total = 0.00;
		}

		#endregion
	}
}
