﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.ComponentModel;

namespace Activa_ACH.Interfaces
{
	interface IWorkFile
	{
		#region Events
		event PropertyChangedEventHandler PropertyChanged;
		#endregion

		#region Properties
		List<string> Lines { get; set; }
		bool Approved { get; set; }
		bool Sent { get; set; }
		bool Downloaded { get; set; }
		string FileName { get; set; }
		DateTime EffectiveDate { get; set; }
		double CreditTotal { get; set; }
		int CreditCount { get; set; }
		double DebitTotal { get; set; }
		int DebitCount { get; set; }
		#endregion

		#region Methods
		IWorkFile Clear();
		IWorkFile AppendLine(string S);
		IWorkFile Append(string S);
		IWorkFile Append(List<string> S);
		string GetLine();
		string GetLine(int L);
		List<string> GetLines();
		string GetVerificationFile();
		#endregion
	}
}
