﻿using System.IO;
using Activa_ACH.Helpers;
using Activa_ACH.Interfaces;
using System.Collections.Generic;
using System;
using System.Linq;
using Activa_ACH.Properties;

namespace Activa_ACH.Data
{
	class NACHA : ObservableObject, IWorkFile
	{
		#region Fields
		List<string> _lines = new List<string>();
		bool _approved = false;
		bool _sent = false;
		bool _downloaded = false;
		string _fileName = "";
		DateTime _effectiveDate = DateTime.Now.AddDays(1);
		double _creditTotal = 0;
		double _debitTotal = 0;
		int _creditCount = 0;
		int _debitCount = 0;
		#endregion

		#region Constructors
		public NACHA()
		{
		}
		#endregion

		#region Properties
		public List<string> Lines
		{
			get
			{
				return _lines;
			}
			set
			{
				_lines = value;
			}
		}
		public bool Sent
		{
			get
			{
				return _sent;
			}
			set
			{
				if (_sent != value)
				{
					_sent = value;
					OnPropertyChanged("Sent");
				}
			}
		}
		public bool Downloaded
		{
			get
			{
				return _downloaded;
			}
			set
			{
				if (_downloaded != value)
				{
					_downloaded = value;
					OnPropertyChanged("Downloaded");
				}
			}
		}

		public string FileName
		{
			get
			{
				return _fileName;
			}

			set
			{
				if (_fileName != value)
				{
					_fileName = value;
					OnPropertyChanged("FileName");
				}
			}
		}

		public DateTime EffectiveDate
		{
			get
			{
				return _effectiveDate;
			}

			set
			{
				if (_effectiveDate != value)
				{
					_effectiveDate = value;
					OnPropertyChanged("EffectiveDate");
				}
			}
		}

		public double DebitTotal
		{
			get
			{
				return _debitTotal;
			}

			set
			{
				if (_debitTotal != value)
				{
					_debitTotal = value;
					OnPropertyChanged("DebitTotal");
				}
			}
		}

		public double CreditTotal
		{
			get
			{
				return _creditTotal;
			}

			set
			{
				if (_creditTotal != value)
				{
					_creditTotal = value;
					OnPropertyChanged("CreditTotal");
				}
			}
		}

		public int CreditCount
		{
			get
			{
				return _creditCount;
			}

			set
			{
				if (_creditCount != value)
				{
					_creditCount = value;
					OnPropertyChanged("CreditCount");
				}
			}
		}

		public int DebitCount
		{
			get
			{
				return _debitCount;
			}

			set
			{
				if (_debitCount != value)
				{
					_debitCount = value;
					OnPropertyChanged("DebitCount");
				}
			}
		}

		public bool Approved
		{
			get
			{
				return _approved;
			}

			set
			{
				if (_approved != value)
				{
					_approved = value;
					OnPropertyChanged("Approved");
				}
			}
		}
		#endregion

		#region Methods
		public IWorkFile Clear()
		{
			Lines.Clear();
			Approved = false;
			Sent = false;
			Downloaded = false;
			CreditCount = 0;
			CreditTotal = 0;
			DebitCount = 0;
			DebitTotal = 0;
			EffectiveDate = DateTime.Now.AddDays(1);
			return this;
		}
		
		public IWorkFile AppendLine(string Line)
		{
			Lines.Add(Line);
			return this;
		}

		public IWorkFile Append(string str)
		{
			if (Lines.Count == 0)
				Lines.Add(str);
			else
				Lines[Lines.Count] += str;
			return this;
		}

		public IWorkFile Append(List<string> L)
		{
			Lines.AddRange(L);
			return this;
		}

		public string GetLine()
		{
			return Lines[Lines.Count];
		}

		public string GetLine(int L)
		{
			return Lines[L];
		}

		public List<string> GetLines()
		{
			return Lines;
		}

		public string GetVerificationFile()
		{
			List<string> VerificationFile = new List<string>();
			if (File.Exists("./FileFormats/ACHVerification.txt"))
			{
				VerificationFile = File.ReadAllLines("./FileFormats/ACHVerification.txt").ToList();
			}
			else
				throw new FileNotFoundException("VerificationFile Not found");

			VerificationFile[1] += DateTime.Now.ToShortDateString();
			VerificationFile[3] += Settings.Default.verificationCompanyName;
			VerificationFile[4] += Settings.Default.verificationCompanyID;
			VerificationFile[6] += Settings.Default.verificationPointName;
			VerificationFile[8] += Settings.Default.verificationContactName;
			VerificationFile[9] += Settings.Default.verificationContactNumber;
			VerificationFile[11] += EffectiveDate.ToShortDateString();
			VerificationFile[14] += "".PadLeft(26, ' ') + "$" + DebitTotal.ToString("0.00").PadLeft(13, ' ') + "".PadLeft(12, ' ') + "$" + CreditTotal.ToString("0.00").PadLeft(13, ' ');
			VerificationFile[15] += "".PadLeft(36, ' ') + DebitCount.ToString().PadLeft(7, ' ') + "".PadLeft(19, ' ') + CreditCount.ToString().PadLeft(7, ' ');

			VerificationFile = (
								from str in VerificationFile
								select str.PadRight(94, ' ')
							   ).ToList();

			return string.Join("\n", VerificationFile);
		}

		public override string ToString()
		{
			return string.Join("\n", Lines);
		}

		#endregion
	}
}
