﻿using System.Collections.Generic;
using System.Linq;
using System.Windows.Input;
using Activa_ACH.Helpers;
using Activa_ACH.Pages;
using Activa_ACH.Data;
using Activa_ACH.Interfaces;
using Activa_ACH.SettingsWindow;

namespace Activa_ACH
{
	class ApplicationViewModel : ObservableObject, IApplicationModel
	{
		#region Fields
		private ICommand _changePageCommand;

		private IPageViewModel _currentPageViewModel;
		private List<IPageViewModel> _pageViewModels;

		#endregion

		#region Constructor
		public ApplicationViewModel()
		{
			//Instantiate NACHA
			CurrentFile = new NACHA();

			// Add available pages
			PageViewModels.Add(new HomeViewModel(this,CurrentFile));
			PageViewModels.Add(new ReceiveViewModel(this,CurrentFile));
			PageViewModels.Add(new ApproveViewModel(this,CurrentFile));
			PageViewModels.Add(new SendViewModel(this,CurrentFile));
			PageViewModels.Add(new CompleteViewModel(this,CurrentFile));

			// Set starting page
			CurrentPageViewModel = PageViewModels[0];

			//setup the settings modal
			//SettingsModal.DataContext = new SettingsViewModel();
		}
		#endregion

		#region Properties / Commands

		//public SettingsModalWindow SettingsModal { get; set; } = new SettingsModalWindow();

		public ICommand ChangePageCommand
		{
			get
			{
				if (_changePageCommand == null)
				{
					_changePageCommand = new RelayCommand(
						p => ChangeViewModel((IPageViewModel)p),
						p => p is IPageViewModel);
				}

				return _changePageCommand;
			}
		}

		public List<IPageViewModel> PageViewModels
		{
			get
			{
				if (_pageViewModels == null)
					_pageViewModels = new List<IPageViewModel>();

				return _pageViewModels;
			}
		}

		public IPageViewModel CurrentPageViewModel
		{
			get
			{
				return _currentPageViewModel;
			}
			set
			{
				if (_currentPageViewModel != value)
				{
					_currentPageViewModel = value;
					OnPropertyChanged("CurrentPageViewModel");
				}
			}
		}

		public string CurrentView
		{
			get
			{
				return _currentPageViewModel.Name;
			}
		}

		public NACHA CurrentFile;

		#endregion

		#region Methods

		private void ChangeViewModel(IPageViewModel viewModel)
		{
			if (!PageViewModels.Contains(viewModel))
				PageViewModels.Add(viewModel);

			CurrentPageViewModel = PageViewModels
				.FirstOrDefault(vm => vm == viewModel);
		}

		public void ChangeViewModel(string viewModel)
		{
			if (PageViewModels.Where(vm => vm.Name == viewModel).Count() > 0)
				CurrentPageViewModel = PageViewModels.FirstOrDefault(vm => vm.Name == viewModel);
		}

		#endregion
	}
}
